import React from 'react';
import { X } from 'lucide-react';
import { Assistant } from '../types/assistant';

interface AssistantSelectorProps {
  isOpen: boolean;
  onClose: () => void;
  onSelect: (assistant: Assistant) => void;
  assistants: Assistant[];
}

export default function AssistantSelector({ isOpen, onClose, onSelect, assistants }: AssistantSelectorProps) {
  if (!isOpen) return null;

  return (
    <div className="fixed inset-0 bg-black/50 backdrop-blur-sm z-50 flex items-center justify-center p-4">
      <div className="bg-white rounded-2xl shadow-xl max-w-2xl w-full max-h-[80vh] overflow-hidden">
        <div className="p-6 border-b border-gray-200 flex justify-between items-center">
          <h2 className="text-2xl font-bold text-gray-900">Try Your Assistant</h2>
          <button
            onClick={onClose}
            className="p-2 hover:bg-gray-100 rounded-full transition-colors"
          >
            <X className="h-6 w-6 text-gray-500" />
          </button>
        </div>
        
        <div className="p-6 overflow-y-auto max-h-[60vh]">
          <div className="grid grid-cols-1 sm:grid-cols-2 gap-4">
            {assistants.map((assistant) => (
              <button
                key={assistant.id}
                onClick={() => {
                  onSelect(assistant);
                  onClose();
                }}
                className="flex items-start space-x-4 p-4 rounded-xl hover:bg-gray-50 transition-colors text-left border border-gray-200 hover:border-indigo-500"
              >
                <div className="p-2 rounded-lg bg-gradient-to-br from-indigo-500 to-purple-600 shrink-0">
                  {assistant.icon}
                </div>
                <div>
                  <h3 className="font-semibold text-gray-900">{assistant.name}</h3>
                  <p className="text-sm text-gray-500 mt-1">{assistant.description}</p>
                </div>
              </button>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
}