import React from 'react';
import { Globe2 } from 'lucide-react';

export default function LanguageSupport() {
  return (
    <div className="py-16 relative overflow-hidden">
      {/* Background effects */}
      <div className="absolute inset-0 bg-gradient-to-b from-slate-950 via-blue-950/50 to-slate-950"></div>
      <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1451187580459-43490279c0fa?q=80&w=2072&auto=format&fit=crop')] 
                    bg-cover bg-center opacity-10"></div>
      <div className="absolute inset-0 bg-gradient-radial from-blue-500/10 via-transparent to-transparent"></div>
      
      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex flex-col lg:flex-row items-center gap-12">
          {/* Left side - Text content */}
          <div className="flex-1 text-center lg:text-left">
            <h2 className="text-4xl md:text-5xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-cyan-300 mb-6">
              Seamless Global Communication
            </h2>
            <p className="text-xl text-blue-100 mb-8 max-w-2xl mx-auto lg:mx-0">
              Break language barriers with ClaraAI's advanced multilingual capabilities. 
              Our AI assistants communicate fluently in over 30 languages, enabling 
              truly global business operations.
            </p>
          </div>

          {/* Right side - Interactive Globe */}
          <div className="flex-1 relative">
            <div className="relative w-full aspect-square max-w-lg mx-auto">
              {/* Central AI Avatar */}
              <div className="absolute inset-0 flex items-center justify-center">
                <div className="w-32 h-32 rounded-full bg-gradient-to-r from-blue-500 to-cyan-400 p-1 animate-pulse-slow">
                  <div className="w-full h-full rounded-full bg-slate-950 flex items-center justify-center">
                    <Globe2 className="w-16 h-16 text-blue-400" />
                  </div>
                </div>
              </div>

              {/* Orbiting Language Bubbles */}
              <div className="absolute inset-0 animate-spin-slow">
                {[...Array(12)].map((_, i) => (
                  <div
                    key={i}
                    className="absolute w-16 h-16 transform -translate-x-1/2 -translate-y-1/2"
                    style={{
                      left: '50%',
                      top: '50%',
                      transform: `rotate(${i * 30}deg) translateY(-120px) rotate(-${i * 30}deg)`
                    }}
                  >
                    <div className="w-full h-full rounded-full bg-gradient-to-r from-blue-500/20 to-cyan-400/20 
                                  backdrop-blur-sm p-0.5 hover:from-blue-500 hover:to-cyan-400 transition-all 
                                  cursor-pointer group">
                      <div className="w-full h-full rounded-full bg-slate-900/90 flex items-center justify-center 
                                    text-blue-300 group-hover:text-white transition-colors">
                        {['EN', 'ES', 'FR', 'DE', 'IT', 'PT', 'JA', 'KO', 'ZH', 'RU', 'AR', 'HI'][i]}
                      </div>
                    </div>
                  </div>
                ))}
              </div>

              {/* Glowing Effects */}
              <div className="absolute inset-0 bg-gradient-radial from-blue-500/20 via-transparent to-transparent 
                            animate-pulse-slow"></div>
            </div>
          </div>
        </div>

        {/* Language Support Stats */}
        <div className="mt-16 grid grid-cols-2 md:grid-cols-4 gap-8">
          {[
            { label: 'Languages', value: '30+' },
            { label: 'Accents', value: '50+' },
            { label: 'Voice Models', value: '100+' },
            { label: 'Countries Served', value: '120+' }
          ].map((stat, i) => (
            <div key={i} className="text-center">
              <div className="text-3xl font-bold text-blue-400 mb-2">{stat.value}</div>
              <div className="text-blue-200/80">{stat.label}</div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
}