import React from 'react';
import { Star, Quote } from 'lucide-react';

const testimonials = [
  {
    name: 'Sarah Johnson',
    role: 'Business Owner',
    content: 'ClaraAI has transformed how we handle customer support. The AI assistants are incredibly efficient and natural in their interactions.',
    rating: 5,
    gradient: 'from-blue-500 to-indigo-600'
  },
  {
    name: 'Michael Chen',
    role: 'Tech Executive',
    content: 'The customization options and industry-specific features have made ClaraAI an invaluable part of our operations.',
    rating: 5,
    gradient: 'from-purple-500 to-pink-600'
  },
  {
    name: 'Emily Rodriguez',
    role: 'Healthcare Administrator',
    content: 'Our patient scheduling and follow-ups have never been more organized. ClaraAI has significantly improved our workflow.',
    rating: 5,
    gradient: 'from-emerald-500 to-teal-600'
  }
];

export default function Testimonials() {
  return (
    <div className="py-24 relative overflow-hidden">
      {/* Background Effects */}
      <div className="absolute inset-0 bg-gradient-to-b from-slate-950 via-indigo-950/20 to-slate-950"></div>
      <div className="absolute inset-0 bg-[radial-gradient(ellipse_at_center,rgba(99,102,241,0.1),transparent_50%)]"></div>

      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl font-bold mb-4">
            <span className="text-white">What Our </span>
            <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-indigo-400">
              Users Say
            </span>
          </h2>
          <p className="text-lg text-blue-200 max-w-2xl mx-auto">
            Discover how ClaraAI is transforming businesses across industries
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {testimonials.map((testimonial, index) => (
            <div
              key={index}
              className="group relative bg-slate-900/50 backdrop-blur-xl rounded-2xl border border-slate-700/50 
                       overflow-hidden transition-all duration-300 hover:border-indigo-500/30 hover:-translate-y-1"
            >
              {/* Animated Background */}
              <div className="absolute inset-0 bg-gradient-to-br opacity-0 group-hover:opacity-100 transition-opacity duration-500"
                   style={{ backgroundImage: `linear-gradient(to bottom right, ${testimonial.gradient})`, opacity: 0.1 }}></div>

              <div className="relative p-8">
                {/* Quote Icon */}
                <div className="absolute top-4 right-4 opacity-10">
                  <Quote className="w-16 h-16 text-current" />
                </div>

                {/* Rating */}
                <div className="flex mb-4">
                  {[...Array(testimonial.rating)].map((_, i) => (
                    <Star key={i} className="h-5 w-5 text-yellow-400 fill-current" />
                  ))}
                </div>

                {/* Content */}
                <p className="text-slate-300 mb-6 relative z-10">{testimonial.content}</p>

                {/* Author */}
                <div className="flex items-center gap-4">
                  <div className={`w-12 h-12 rounded-xl bg-gradient-to-br ${testimonial.gradient} 
                                flex items-center justify-center transform transition-transform 
                                group-hover:scale-110 group-hover:rotate-3`}>
                    <span className="text-xl font-bold text-white">
                      {testimonial.name.charAt(0)}
                    </span>
                  </div>
                  <div>
                    <p className="font-semibold text-white">{testimonial.name}</p>
                    <p className="text-sm text-slate-400">{testimonial.role}</p>
                  </div>
                </div>

                {/* Hover Effect */}
                <div className="absolute bottom-0 left-0 right-0 h-1 bg-gradient-to-r opacity-0 
                              group-hover:opacity-100 transition-opacity duration-300"
                     style={{ backgroundImage: `linear-gradient(to right, ${testimonial.gradient})` }}></div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
}