import React from 'react';
import HeroSection from '../components/HeroSection';
import AssistantDashboard from '../components/AssistantDashboard';
import VoiceAgentCreator from '../components/VoiceAgentCreator';
import Pricing from '../components/Pricing';
import CallScheduler from '../components/CallScheduler';
import SalesAssistant from '../components/SalesAssistant';
import UseCaseExplorer from '../components/UseCaseExplorer';
import Features from '../components/Features';
import Testimonials from '../components/Testimonials';
import FAQ from '../components/FAQ';
import LanguageSupport from '../components/LanguageSupport';

export default function HomePage() {
  return (
    <div>
      <HeroSection />
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <AssistantDashboard />
        <VoiceAgentCreator />
        <Pricing />
        <div className="grid md:grid-cols-2 gap-8 mb-16 mt-16">
          <CallScheduler />
          <SalesAssistant />
        </div>
        <UseCaseExplorer />
        <Features />
        <Testimonials />
        <FAQ />
        <LanguageSupport />
      </div>
    </div>
  );
}