import React from 'react';
import { Bot } from 'lucide-react';

export default function HeroSection() {
  return (
    <div className="relative min-h-[80vh] flex items-center justify-center overflow-hidden">
      {/* Background gradients and effects */}
      <div className="absolute inset-0 bg-gradient-to-b from-slate-950 via-blue-950 to-slate-950"></div>
      <div className="absolute inset-0 bg-[radial-gradient(circle_at_center,rgba(59,130,246,0.1),transparent_50%)]"></div>
      <div className="absolute inset-0 bg-grid-pattern opacity-10"></div>

      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24 text-center">
        <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-blue-500/10 border border-blue-500/20 text-blue-300 mb-8">
          <span className="text-sm">Announcing our next-gen AI model</span>
          <span className="text-xs bg-blue-500/20 px-2 py-0.5 rounded-full">New</span>
        </div>

        <h1 className="text-5xl md:text-7xl font-bold text-center mb-8 bg-clip-text text-transparent bg-gradient-to-b from-blue-400 to-blue-600">
          AI-Powered<br />
          Conversations That Feel<br />
          Human
        </h1>

        <div className="flex justify-center mb-12">
          <Bot className="w-24 h-24 text-blue-500 animate-float" />
        </div>

        <p className="text-xl md:text-2xl text-blue-100 max-w-3xl mx-auto mb-6">
          Transform your customer experience with AI that understands, learns, and evolves.
        </p>
        <p className="text-lg text-blue-200 mb-12">
          ClaraAI delivers human-like interactions at scale.
        </p>

        <div className="flex flex-col sm:flex-row gap-4 justify-center">
          <button className="px-8 py-4 bg-blue-600 hover:bg-blue-500 text-white rounded-xl font-semibold 
                           transition-all hover:scale-105 shadow-lg shadow-blue-500/25">
            Start Free Trial
          </button>
          <button className="px-8 py-4 bg-slate-900/50 hover:bg-slate-900/70 text-blue-300 rounded-xl 
                           font-semibold border border-blue-500/30 transition-all hover:scale-105">
            Book a Demo
          </button>
        </div>
      </div>

      {/* Animated gradient border */}
      <div className="absolute bottom-0 left-0 right-0 h-px bg-gradient-to-r from-transparent via-blue-500 to-transparent 
                    opacity-50"></div>
    </div>
  );
}