import React from 'react';
import { Bot, Users, Globe, Award } from 'lucide-react';

export default function AboutPage() {
  return (
    <div className="pt-8">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h1 className="text-4xl md:text-5xl font-bold text-center mb-12">
          <span className="text-white">About </span>
          <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-indigo-400">
            ClaraAI
          </span>
        </h1>

        <div className="prose prose-lg prose-invert mx-auto mb-16">
          <p className="text-xl text-blue-200 text-center max-w-3xl mx-auto mb-16">
            We're on a mission to revolutionize customer interactions through advanced AI technology,
            making human-like conversations accessible to businesses of all sizes.
          </p>

          <div className="grid md:grid-cols-2 gap-12 mb-16">
            <div className="bg-slate-900/50 rounded-2xl p-8 border border-blue-500/20">
              <h2 className="text-2xl font-bold text-white mb-4">Our Story</h2>
              <p className="text-slate-300">
                Founded in 2023, ClaraAI emerged from a vision to transform how businesses interact
                with their customers. We combine cutting-edge AI technology with a deep understanding
                of customer service to create truly intelligent conversation agents.
              </p>
            </div>

            <div className="bg-slate-900/50 rounded-2xl p-8 border border-blue-500/20">
              <h2 className="text-2xl font-bold text-white mb-4">Our Mission</h2>
              <p className="text-slate-300">
                We're dedicated to making advanced AI technology accessible to businesses worldwide,
                helping them deliver exceptional customer experiences while improving operational
                efficiency.
              </p>
            </div>
          </div>

          <div className="grid grid-cols-2 md:grid-cols-4 gap-8 mb-16">
            {[
              { icon: Bot, label: 'AI Conversations', value: '1M+' },
              { icon: Users, label: 'Happy Customers', value: '10K+' },
              { icon: Globe, label: 'Countries', value: '50+' },
              { icon: Award, label: 'Awards', value: '15+' }
            ].map((stat, index) => (
              <div key={index} className="text-center">
                <div className="w-16 h-16 mx-auto mb-4 rounded-2xl bg-gradient-to-br from-blue-500 to-indigo-600 
                              flex items-center justify-center">
                  <stat.icon className="w-8 h-8 text-white" />
                </div>
                <div className="text-3xl font-bold text-white mb-2">{stat.value}</div>
                <div className="text-blue-300">{stat.label}</div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
}