import React from 'react';
import { Mail, Phone, MapPin, MessageSquare } from 'lucide-react';

export default function ContactPage() {
  return (
    <div className="pt-8">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h1 className="text-4xl md:text-5xl font-bold text-center mb-12">
          <span className="text-white">Get in </span>
          <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-indigo-400">
            Touch
          </span>
        </h1>

        <div className="grid md:grid-cols-2 gap-12 mb-16">
          <div>
            <h2 className="text-2xl font-bold text-white mb-6">Contact Information</h2>
            <div className="space-y-6">
              <div className="flex items-center gap-4">
                <div className="w-12 h-12 rounded-lg bg-blue-500/20 flex items-center justify-center">
                  <Mail className="w-6 h-6 text-blue-400" />
                </div>
                <div>
                  <div className="text-sm text-blue-300">Email</div>
                  <div className="text-white">contact@claraai.com</div>
                </div>
              </div>

              <div className="flex items-center gap-4">
                <div className="w-12 h-12 rounded-lg bg-blue-500/20 flex items-center justify-center">
                  <Phone className="w-6 h-6 text-blue-400" />
                </div>
                <div>
                  <div className="text-sm text-blue-300">Phone</div>
                  <div className="text-white">+1 (555) 123-4567</div>
                </div>
              </div>

              <div className="flex items-center gap-4">
                <div className="w-12 h-12 rounded-lg bg-blue-500/20 flex items-center justify-center">
                  <MapPin className="w-6 h-6 text-blue-400" />
                </div>
                <div>
                  <div className="text-sm text-blue-300">Address</div>
                  <div className="text-white">123 AI Street, San Francisco, CA 94105</div>
                </div>
              </div>
            </div>
          </div>

          <div className="bg-slate-900/50 rounded-2xl p-8 border border-blue-500/20">
            <h2 className="text-2xl font-bold text-white mb-6">Send us a Message</h2>
            <form className="space-y-6">
              <div>
                <label className="block text-sm font-medium text-blue-300 mb-2">Name</label>
                <input
                  type="text"
                  className="w-full px-4 py-3 bg-slate-800/50 border border-blue-500/30 rounded-xl 
                           text-white placeholder-blue-300/50 focus:border-blue-400 focus:ring-1 
                           focus:ring-blue-400"
                  placeholder="Your name"
                />
              </div>

              <div>
                <label className="block text-sm font-medium text-blue-300 mb-2">Email</label>
                <input
                  type="email"
                  className="w-full px-4 py-3 bg-slate-800/50 border border-blue-500/30 rounded-xl 
                           text-white placeholder-blue-300/50 focus:border-blue-400 focus:ring-1 
                           focus:ring-blue-400"
                  placeholder="your@email.com"
                />
              </div>

              <div>
                <label className="block text-sm font-medium text-blue-300 mb-2">Message</label>
                <textarea
                  rows={4}
                  className="w-full px-4 py-3 bg-slate-800/50 border border-blue-500/30 rounded-xl 
                           text-white placeholder-blue-300/50 focus:border-blue-400 focus:ring-1 
                           focus:ring-blue-400"
                  placeholder="Your message"
                />
              </div>

              <button
                type="submit"
                className="w-full py-3 px-6 bg-gradient-to-r from-blue-500 to-indigo-600 text-white 
                         rounded-xl font-medium hover:from-blue-600 hover:to-indigo-700 
                         transition-all flex items-center justify-center gap-2"
              >
                <MessageSquare className="w-5 h-5" />
                <span>Send Message</span>
              </button>
            </form>
          </div>
        </div>
      </div>
    </div>
  );
}