import React from 'react';
import { Brain, Clock, Shield } from 'lucide-react';

const features = [
  {
    icon: Brain,
    title: 'AI-Powered Assistance',
    description: 'Advanced GPT-3.5 model provides intelligent guidance and personalized support.',
    gradient: 'from-blue-500 to-indigo-600'
  },
  {
    icon: Clock,
    title: 'Smart Scheduling',
    description: 'Optimized scheduling with automated follow-ups and reminders.',
    gradient: 'from-purple-500 to-pink-600'
  },
  {
    icon: Shield,
    title: 'Secure & Private',
    description: 'Your data is encrypted and protected with enterprise-grade security measures.',
    gradient: 'from-emerald-500 to-teal-600'
  }
];

export default function Features() {
  return (
    <div className="py-24 relative overflow-hidden">
      {/* Background Effects */}
      <div className="absolute inset-0 bg-gradient-to-b from-slate-950 via-blue-950/20 to-slate-950"></div>
      <div className="absolute inset-0 bg-[radial-gradient(ellipse_at_center,rgba(59,130,246,0.1),transparent_50%)]"></div>
      
      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl font-bold mb-4">
            <span className="text-white">Powered by </span>
            <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-indigo-400">
              Advanced AI
            </span>
          </h2>
          <p className="text-lg text-blue-200 max-w-2xl mx-auto">
            Experience the future of customer interaction with our cutting-edge AI technology
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {features.map((feature, index) => (
            <div
              key={index}
              className="group relative bg-slate-900/50 backdrop-blur-xl rounded-2xl border border-slate-700/50 
                       overflow-hidden transition-all duration-300 hover:border-blue-500/30 hover:-translate-y-1"
            >
              {/* Animated Background */}
              <div className="absolute inset-0 bg-gradient-to-br opacity-0 group-hover:opacity-100 transition-opacity duration-500"
                   style={{ backgroundImage: `linear-gradient(to bottom right, ${feature.gradient})`, opacity: 0.1 }}></div>
              
              <div className="relative p-8">
                <div className={`w-16 h-16 rounded-xl bg-gradient-to-br ${feature.gradient} 
                              flex items-center justify-center mb-6 transform transition-transform 
                              group-hover:scale-110 group-hover:rotate-3`}>
                  <feature.icon className="h-8 w-8 text-white" />
                </div>
                
                <h3 className="text-xl font-semibold text-white mb-4">{feature.title}</h3>
                <p className="text-slate-300">{feature.description}</p>

                {/* Hover Effect */}
                <div className="absolute bottom-0 left-0 right-0 h-1 bg-gradient-to-r opacity-0 
                              group-hover:opacity-100 transition-opacity duration-300"
                     style={{ backgroundImage: `linear-gradient(to right, ${feature.gradient})` }}></div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
}