import React, { useState } from 'react';
import { Building2, Sun, Heart, Headphones, CreditCard, Bot, Home, Plus } from 'lucide-react';

interface UseCase {
  id: string;
  icon: React.ReactNode;
  label: string;
  color: string;
}

const useCases: UseCase[] = [
  {
    id: 'real-estate',
    icon: <Building2 className="w-5 h-5" />,
    label: 'Real Estate',
    color: 'from-blue-400 to-cyan-400'
  },
  {
    id: 'solar',
    icon: <Sun className="w-5 h-5" />,
    label: 'Solar',
    color: 'from-amber-400 to-orange-400'
  },
  {
    id: 'health',
    icon: <Heart className="w-5 h-5" />,
    label: 'Health Insurance',
    color: 'from-rose-400 to-pink-400'
  },
  {
    id: 'tech',
    icon: <Headphones className="w-5 h-5" />,
    label: 'Tech Support',
    color: 'from-violet-400 to-purple-400'
  },
  {
    id: 'credit',
    icon: <CreditCard className="w-5 h-5" />,
    label: 'Credit Repair',
    color: 'from-emerald-400 to-teal-400'
  },
  {
    id: 'ai',
    icon: <Bot className="w-5 h-5" />,
    label: 'AI Agency',
    color: 'from-indigo-400 to-blue-400'
  },
  {
    id: 'spanish',
    icon: <Home className="w-5 h-5" />,
    label: 'Spanish Speaking Real Estate',
    color: 'from-fuchsia-400 to-pink-400'
  }
];

export default function UseCaseExplorer() {
  const [activeCase, setActiveCase] = useState<string | null>(null);

  return (
    <div className="relative py-24 overflow-hidden">
      {/* Background Effects */}
      <div className="absolute inset-0 bg-gradient-to-b from-slate-950 via-blue-950/20 to-slate-950"></div>
      <div className="absolute inset-0 bg-[radial-gradient(circle_at_center,rgba(59,130,246,0.1),transparent_50%)]"></div>
      
      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl font-bold mb-4">
            <span className="text-white">Explore Assistants For </span>
            <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-indigo-400">
              Different Use Cases
            </span>
          </h2>
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
          {/* Left side - Use Case List */}
          <div className="space-y-3">
            {useCases.map((useCase) => (
              <button
                key={useCase.id}
                onClick={() => setActiveCase(useCase.id)}
                className={`w-full group relative flex items-center gap-3 px-6 py-4 rounded-xl 
                          transition-all duration-300 hover:translate-x-2
                          ${activeCase === useCase.id 
                            ? 'bg-gradient-to-r from-blue-500/20 to-indigo-500/20 border border-blue-500/30' 
                            : 'bg-slate-900/50 border border-slate-700/50 hover:border-blue-500/30'}`}
              >
                <div className={`w-10 h-10 rounded-lg bg-gradient-to-br ${useCase.color} 
                              flex items-center justify-center transform transition-transform 
                              group-hover:scale-110`}>
                  {useCase.icon}
                </div>
                <span className="text-lg text-white">{useCase.label}</span>
                <Plus className={`w-5 h-5 ml-auto transition-all duration-300
                               ${activeCase === useCase.id 
                                 ? 'rotate-45 text-blue-400' 
                                 : 'text-slate-400 group-hover:text-blue-400'}`} />
              </button>
            ))}
          </div>

          {/* Right side - Interactive Visualization */}
          <div className="relative aspect-square">
            {/* Central Orbit */}
            <div className="absolute inset-0 flex items-center justify-center">
              <div className="w-48 h-48 rounded-full border-2 border-blue-500/30 
                            animate-spin-slow relative">
                <div className="absolute inset-0 rounded-full border-2 border-transparent 
                              border-t-blue-500/50 animate-pulse-slow"></div>
                
                {/* Floating Icons */}
                {[0, 60, 120, 180, 240, 300].map((rotation, i) => (
                  <div
                    key={i}
                    className="absolute w-10 h-10 transform -translate-x-1/2 -translate-y-1/2"
                    style={{
                      left: '50%',
                      top: '50%',
                      transform: `rotate(${rotation}deg) translateY(-100px) rotate(-${rotation}deg)`
                    }}
                  >
                    <div className="w-full h-full rounded-lg bg-gradient-to-br from-blue-500 to-indigo-600 
                                  animate-float flex items-center justify-center">
                      <Bot className="w-5 h-5 text-white" />
                    </div>
                  </div>
                ))}
              </div>
            </div>

            {/* Central Icon */}
            <div className="absolute inset-0 flex items-center justify-center">
              <div className="w-24 h-24 rounded-2xl bg-gradient-to-br from-blue-500 to-indigo-600 
                            animate-pulse-ring flex items-center justify-center">
                <Bot className="w-12 h-12 text-white" />
              </div>
            </div>

            {/* Particle Effects */}
            <div className="absolute inset-0">
              <div className="absolute inset-0 bg-gradient-radial from-blue-500/10 via-transparent to-transparent 
                            animate-pulse-slow"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}