import React from 'react';
import { Wand2, Mic, Settings2, Play } from 'lucide-react';

const agentProfiles = [
  {
    image: "https://images.unsplash.com/photo-1560250097-0b93528c311a?w=400&h=400&auto=format&fit=crop&q=80",
    color: "from-blue-500 to-indigo-600"
  },
  {
    image: "https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?w=400&h=400&auto=format&fit=crop&q=80",
    color: "from-purple-500 to-pink-600"
  },
  {
    image: "https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=400&h=400&auto=format&fit=crop&q=80",
    color: "from-emerald-500 to-teal-600"
  },
  {
    image: "https://images.unsplash.com/photo-1599566150163-29194dcaad36?w=400&h=400&auto=format&fit=crop&q=80",
    color: "from-orange-500 to-red-600"
  }
];

export default function VoiceAgentCreator() {
  return (
    <div className="py-24 relative overflow-hidden">
      {/* Background Effects */}
      <div className="absolute inset-0 bg-gradient-to-b from-slate-950 via-blue-950/20 to-slate-950"></div>
      <div className="absolute inset-0 bg-[radial-gradient(ellipse_at_top,rgba(59,130,246,0.2),transparent_50%)]"></div>
      
      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold mb-6">
            <span className="text-white">Create AI voice agents that</span><br />
            <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-indigo-400">
              sound and behave like real people
            </span>
          </h2>
          <p className="text-lg text-blue-200 max-w-2xl mx-auto">
            Handle your calls with human-like voices and intelligent speech detection for realistic customer interactions.
          </p>
        </div>

        {/* Agent Profiles */}
        <div className="flex justify-center gap-4 mb-16">
          {agentProfiles.map((profile, index) => (
            <div key={index} className="relative group">
              <div className="w-24 h-24 rounded-2xl overflow-hidden transform transition-transform group-hover:scale-105">
                <div className="absolute inset-0 bg-gradient-to-br opacity-80 group-hover:opacity-100 transition-opacity"></div>
                <img 
                  src={profile.image} 
                  alt="AI Agent" 
                  className="w-full h-full object-cover"
                />
                <div className="absolute bottom-2 right-2 w-6 h-6 bg-blue-500 rounded-full flex items-center justify-center">
                  <Mic className="w-3 h-3 text-white" />
                </div>
              </div>
            </div>
          ))}
        </div>

        {/* Agent Creator Interface */}
        <div className="max-w-4xl mx-auto bg-slate-900/80 backdrop-blur-xl rounded-3xl border border-blue-500/20 overflow-hidden">
          <div className="p-8">
            <div className="flex items-center gap-4 mb-8">
              <div className="w-12 h-12 rounded-2xl bg-gradient-to-br from-blue-500 to-indigo-600 flex items-center justify-center">
                <Wand2 className="w-6 h-6 text-white" />
              </div>
              <div>
                <h3 className="text-xl font-semibold text-white">Voice Agent Builder</h3>
                <p className="text-blue-300">Create your custom AI voice agent in minutes</p>
              </div>
            </div>

            <div className="grid grid-cols-2 gap-6">
              <div className="space-y-4">
                <label className="block">
                  <span className="text-sm font-medium text-blue-300">Agent Name</span>
                  <input 
                    type="text"
                    placeholder="Enter agent name"
                    className="mt-1 block w-full rounded-xl bg-slate-800/50 border border-blue-500/30 
                             text-white placeholder-blue-300/50 focus:border-blue-400 focus:ring-1 focus:ring-blue-400"
                  />
                </label>

                <label className="block">
                  <span className="text-sm font-medium text-blue-300">Language</span>
                  <select 
                    className="mt-1 block w-full rounded-xl bg-slate-800/50 border border-blue-500/30 
                             text-white focus:border-blue-400 focus:ring-1 focus:ring-blue-400"
                  >
                    <option>English (US)</option>
                    <option>Spanish</option>
                    <option>French</option>
                    <option>German</option>
                  </select>
                </label>
              </div>

              <div className="space-y-4">
                <label className="block">
                  <span className="text-sm font-medium text-blue-300">Voice Type</span>
                  <select 
                    className="mt-1 block w-full rounded-xl bg-slate-800/50 border border-blue-500/30 
                             text-white focus:border-blue-400 focus:ring-1 focus:ring-blue-400"
                  >
                    <option>Professional and Friendly</option>
                    <option>Warm and Engaging</option>
                    <option>Formal and Authoritative</option>
                    <option>Casual and Energetic</option>
                  </select>
                </label>

                <label className="block">
                  <span className="text-sm font-medium text-blue-300">Industry</span>
                  <select 
                    className="mt-1 block w-full rounded-xl bg-slate-800/50 border border-blue-500/30 
                             text-white focus:border-blue-400 focus:ring-1 focus:ring-blue-400"
                  >
                    <option>Healthcare</option>
                    <option>Technology</option>
                    <option>Finance</option>
                    <option>Retail</option>
                  </select>
                </label>
              </div>
            </div>

            <div className="mt-8 flex justify-between items-center">
              <button className="flex items-center gap-2 text-blue-300 hover:text-blue-200 transition-colors">
                <Settings2 className="w-5 h-5" />
                <span>Advanced Settings</span>
              </button>

              <button className="px-6 py-3 bg-gradient-to-r from-blue-500 to-indigo-600 text-white rounded-xl 
                               font-semibold flex items-center gap-2 hover:from-blue-600 hover:to-indigo-700 
                               transition-all hover:scale-105">
                <Play className="w-5 h-5" />
                <span>Create Agent</span>
              </button>
            </div>
          </div>

          {/* Progress Steps */}
          <div className="bg-slate-950/50 border-t border-blue-500/20 p-4 flex justify-between">
            <div className="flex items-center gap-2">
              <div className="w-8 h-8 rounded-full bg-blue-500 flex items-center justify-center text-white font-medium">
                1
              </div>
              <span className="text-blue-300">Basic Info</span>
            </div>
            <div className="flex items-center gap-2">
              <div className="w-8 h-8 rounded-full bg-slate-800 flex items-center justify-center text-blue-300 font-medium">
                2
              </div>
              <span className="text-blue-300">Voice Setup</span>
            </div>
            <div className="flex items-center gap-2">
              <div className="w-8 h-8 rounded-full bg-slate-800 flex items-center justify-center text-blue-300 font-medium">
                3
              </div>
              <span className="text-blue-300">Review</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}