import React from 'react';
import { Calendar, ShoppingCart, Home, Scale, Hotel, PiggyBank, Scissors, 
         ShoppingBag, FileText, Laptop, Car, Dumbbell, PartyPopper, Calculator,
         Umbrella, Film, Construction, CarFront } from 'lucide-react';
import type { Assistant } from '../types/assistant';

export const assistantData: Assistant[] = [
  {
    id: 1,
    name: 'Emma',
    title: 'Healthcare Appointment Scheduler',
    industry: 'healthcare',
    description: 'Manages patient appointments and follow-ups with automated scheduling.',
    greeting: "Hi, I'm Emma, your personal healthcare scheduling assistant! I specialize in managing patient bookings, sending reminders, and making sure your calendar stays on track. I'm here to simplify your practice's workflow and keep your patients happy and on time.",
    avatar: "https://images.unsplash.com/photo-1573497019940-1c28c88b4f3e?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Calendar),
    isActive: true,
    stats: { activeSessions: 145, successRate: 98 }
  },
  {
    id: 2,
    name: 'Zoe',
    title: 'E-commerce Customer Service Agent',
    industry: 'retail',
    description: 'Handles customer inquiries, order tracking, and product recommendations.',
    greeting: "Hey there! I'm Zoe, the friendly e-commerce expert at your service. Need help with product recommendations, order tracking, or returns? I've got you covered. I'm here to elevate your customer experience and drive more sales.",
    avatar: "https://images.unsplash.com/photo-1580489944761-15a19d654956?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(ShoppingCart),
    isActive: true,
    stats: { activeSessions: 234, successRate: 95 }
  },
  {
    id: 3,
    name: 'Max',
    title: 'Real Estate Lead Manager',
    industry: 'real-estate',
    description: 'Manages property inquiries, schedules viewings, and qualifies leads.',
    greeting: "Hi, I'm Max, your real estate lead manager! I help qualify potential buyers, schedule property tours, and keep your leads engaged. I'm here to make your life easier and your sales pipeline fuller.",
    avatar: "https://images.unsplash.com/photo-1560250097-0b93528c311a?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Home),
    isActive: true,
    stats: { activeSessions: 178, successRate: 92 }
  },
  {
    id: 4,
    name: 'Ava',
    title: 'Legal Assistant',
    industry: 'legal',
    description: 'Handles client intake, appointment scheduling, and document management.',
    greeting: "Hello, I'm Ava, your law firm's virtual legal assistant. I handle client intake, schedule appointments, and keep your documents organized. I make managing cases smooth and efficient, so you can focus on winning them.",
    avatar: "https://images.unsplash.com/photo-1589156191108-c762ff4b96ab?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Scale),
    isActive: true,
    stats: { activeSessions: 156, successRate: 96 }
  },
  {
    id: 5,
    name: 'Bella',
    title: 'Hospitality Booking Assistant',
    industry: 'hospitality',
    description: 'Manages reservations, guest requests, and property information.',
    greeting: "Welcome! I'm Bella, the booking assistant tailored for the hospitality industry. Whether it's reservations, guest requests, or upselling packages, I'm here to enhance your guest experience.",
    avatar: "https://images.unsplash.com/photo-1567532939604-b6b5b0db2604?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Hotel),
    isActive: true,
    stats: { activeSessions: 189, successRate: 94 }
  },
  {
    id: 6,
    name: 'Oliver',
    title: 'Financial Advisor',
    industry: 'finance',
    description: 'Assists with account queries, budgeting, and financial planning.',
    greeting: "Hi, I'm Oliver, your trusted virtual financial advisor. I help with budgeting, account management, and payment reminders. I bring clarity to your finances and help you stay on top of your goals.",
    avatar: "https://images.unsplash.com/photo-1519085360753-af0119f7cbe7?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(PiggyBank),
    isActive: true,
    stats: { activeSessions: 167, successRate: 97 }
  },
  {
    id: 7,
    name: 'Mia',
    title: 'Beauty & Wellness Coordinator',
    industry: 'beauty',
    description: 'Manages beauty appointments, service inquiries, and client follow-ups.',
    greeting: "Hi there! I'm Mia, your beauty and wellness appointment guru. I handle service bookings, reminders, and product inquiries to keep your clients glowing. Your business will shine brighter than ever!",
    avatar: "https://images.unsplash.com/photo-1544005313-94ddf0286df2?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Scissors),
    isActive: true,
    stats: { activeSessions: 198, successRate: 93 }
  },
  {
    id: 8,
    name: 'Jack',
    title: 'Retail Sales Assistant',
    industry: 'retail',
    description: 'Handles inventory queries, customer support, and order management.',
    greeting: "Hello! I'm Jack, your retail expert assistant. I'm here to guide customers through product options, check inventory, and assist with returns. I'm all about enhancing your customer journey and boosting sales.",
    avatar: "https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(ShoppingBag),
    isActive: true,
    stats: { activeSessions: 223, successRate: 91 }
  },
  {
    id: 9,
    name: 'Grace',
    title: 'Medical Billing Assistant',
    industry: 'healthcare',
    description: 'Processes claims, verifies insurance, and handles billing inquiries.',
    greeting: "Hi, I'm Grace, your medical billing pro. I manage claims, verify insurance, and track payments. I take the headaches out of billing and coding for your practice.",
    avatar: "https://images.unsplash.com/photo-1594744803329-e58b31de8bf5?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(FileText),
    isActive: true,
    stats: { activeSessions: 134, successRate: 95 }
  },
  {
    id: 10,
    name: 'Sam',
    title: 'IT Support Specialist',
    industry: 'technology',
    description: 'Provides technical support, troubleshooting, and system guidance.',
    greeting: "Hey there, I'm Sam, your IT problem-solver. I troubleshoot issues, escalate problems, and track tickets like a pro. I make tech support fast, simple, and stress-free.",
    avatar: "https://images.unsplash.com/photo-1506794778202-cad84cf45f1d?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Laptop),
    isActive: true,
    stats: { activeSessions: 245, successRate: 89 }
  },
  {
    id: 11,
    name: 'Alex',
    title: 'Automotive Service Assistant',
    industry: 'automotive',
    description: 'Schedules maintenance, handles service inquiries, and tracks repairs.',
    greeting: "Hi, I'm Alex, your automotive service assistant. From scheduling maintenance to notifying recalls, I ensure your shop runs like a well-oiled machine. I'm here to keep your customers' vehicles in top shape.",
    avatar: "https://images.unsplash.com/photo-1500648767791-00dcc994a43e?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Car),
    isActive: true,
    stats: { activeSessions: 167, successRate: 92 }
  },
  {
    id: 12,
    name: 'Lily',
    title: 'Fitness Membership Coordinator',
    industry: 'fitness',
    description: 'Manages gym memberships, class schedules, and fitness planning.',
    greeting: "Hi, I'm Lily, the fitness-focused membership coordinator. I handle sign-ups, class schedules, and renewals to keep your gym thriving. I'm here to keep your members motivated and engaged.",
    avatar: "https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Dumbbell),
    isActive: true,
    stats: { activeSessions: 189, successRate: 94 }
  },
  {
    id: 13,
    name: 'Ethan',
    title: 'Event Planning Assistant',
    industry: 'events',
    description: 'Coordinates events, manages RSVPs, and handles vendor communications.',
    greeting: "Hi, I'm Ethan, your event planning guru. I manage RSVPs, notify attendees, and gather feedback to make your events unforgettable. I keep everything running smoothly.",
    avatar: "https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(PartyPopper),
    isActive: true,
    stats: { activeSessions: 156, successRate: 96 }
  },
  {
    id: 14,
    name: 'Sophia',
    title: 'Tax Assistant',
    industry: 'finance',
    description: 'Helps with tax preparation, documentation, and financial planning.',
    greeting: "Hello! I'm Sophia, your expert tax assistant. I streamline client intake, tax filing, and financial record management. I'm here to maximize deductions and minimize stress for you.",
    avatar: "https://images.unsplash.com/photo-1598550874175-4d0ef436c909?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Calculator),
    isActive: true,
    stats: { activeSessions: 178, successRate: 97 }
  },
  {
    id: 15,
    name: 'Nathan',
    title: 'Insurance Claims Assistant',
    industry: 'insurance',
    description: 'Processes claims, answers policy questions, and handles coverage inquiries.',
    greeting: "Hi, I'm Nathan, your insurance claims expert. I assist customers with policy queries, claims submissions, and progress tracking. I'm here to simplify your claims process and boost client satisfaction.",
    avatar: "https://images.unsplash.com/photo-1463453091185-61582044d556?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Umbrella),
    isActive: true,
    stats: { activeSessions: 145, successRate: 93 }
  },
  {
    id: 16,
    name: 'Ella',
    title: 'Media Talent Coordinator',
    industry: 'entertainment',
    description: 'Manages talent scheduling, production coordination, and client communications.',
    greeting: "Hello, I'm Ella, your go-to talent coordinator. I organize auditions, manage schedules, and keep your talent happy. I help you shine in the spotlight.",
    avatar: "https://images.unsplash.com/photo-1580489944761-15a19d654956?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Film),
    isActive: true,
    stats: { activeSessions: 167, successRate: 91 }
  },
  {
    id: 17,
    name: 'Noah',
    title: 'Construction Project Coordinator',
    industry: 'construction',
    description: 'Coordinates projects, manages schedules, and handles client updates.',
    greeting: "Hey there! I'm Noah, your construction project coordinator. I manage subcontractor schedules, timelines, and client updates. I keep your projects on track and stress-free.",
    avatar: "https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(Construction),
    isActive: true,
    stats: { activeSessions: 134, successRate: 90 }
  },
  {
    id: 18,
    name: 'Ryan',
    title: 'Dealership Sales Coordinator',
    industry: 'automotive',
    description: 'Manages vehicle inquiries, test drives, and service scheduling.',
    greeting: "Hi, I'm Ryan, your dealership's assistant for sales and service. From scheduling test drives to tracking maintenance, I'm here to drive your success. I've got the horsepower to elevate your business.",
    avatar: "https://images.unsplash.com/photo-1519085360753-af0119f7cbe7?w=400&h=400&auto=format&fit=crop&q=80",
    icon: React.createElement(CarFront),
    isActive: true,
    stats: { activeSessions: 189, successRate: 94 }
  }
];