import React from 'react';
import { Calendar } from 'lucide-react';

const blogPosts = [
  {
    title: 'The Future of AI Voice Assistants',
    excerpt: 'Explore how AI is revolutionizing customer service and business communications.',
    date: '2024-03-15',
    category: 'Technology',
    image: 'https://images.unsplash.com/photo-1677442136019-21780ecad995?w=800&auto=format&fit=crop&q=60'
  },
  {
    title: 'Maximizing Customer Engagement with AI',
    excerpt: 'Learn how businesses are leveraging AI to improve customer satisfaction.',
    date: '2024-03-10',
    category: 'Business',
    image: 'https://images.unsplash.com/photo-1552664730-d307ca884978?w=800&auto=format&fit=crop&q=60'
  },
  // Add more blog posts as needed
];

export default function BlogPage() {
  return (
    <div className="pt-8">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h1 className="text-4xl md:text-5xl font-bold text-center mb-12">
          <span className="text-white">Latest from Our </span>
          <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-indigo-400">
            Blog
          </span>
        </h1>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {blogPosts.map((post, index) => (
            <article
              key={index}
              className="bg-slate-900/50 rounded-2xl overflow-hidden border border-blue-500/20 
                       hover:border-blue-500/40 transition-all hover:-translate-y-1"
            >
              <img
                src={post.image}
                alt={post.title}
                className="w-full h-48 object-cover"
              />
              <div className="p-6">
                <div className="flex items-center gap-2 text-blue-400 text-sm mb-4">
                  <Calendar className="w-4 h-4" />
                  <time>{post.date}</time>
                  <span className="text-slate-400">•</span>
                  <span className="text-blue-300">{post.category}</span>
                </div>
                <h2 className="text-xl font-bold text-white mb-4">{post.title}</h2>
                <p className="text-slate-300 mb-6">{post.excerpt}</p>
                <a
                  href="#"
                  className="text-blue-400 hover:text-blue-300 font-medium transition-colors"
                >
                  Read More →
                </a>
              </div>
            </article>
          ))}
        </div>
      </div>
    </div>
  );
}